//
// $Id: fd.h,v 1.4 2001/07/13 15:15:06 nishi Exp $
//
// Copyright (C) 2001 Shouhei Nishi.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//





#if BX_USE_FDBIOS_SMF
#  define BX_FD_BIOS_SMF  static
#  define BX_FD_BIOS_THIS bx_fd_bios.
#else
#  define BX_FD_BIOS_SMF
#  define BX_FD_BIOS_THIS this->
#endif

#define NUM_FLOPPY 4

class bx_fd_bios_c : public logfunctions {
public:
  bx_fd_bios_c(void);
  ~bx_fd_bios_c(void);

  BX_FD_BIOS_SMF void init(bx_bios_c *, bx_disk_bios_c *);

  BX_FD_BIOS_SMF void bios_exec(BX_CPU_C *cpu,
				int type,
				Bit32u addr,
				Bit32u errorno,
				Boolean isPM,
				int &exittype,
				Bit32u &exitaddr,
				Bit16u &exitseg,
				Bit64u &leasttime,
				Bit64u &maxtime);

private:

  struct {
    floppy_t media[2];
    unsigned num_supported_floppies;
    Boolean  media_present[NUM_FLOPPY];
    } s;  // state information

  bx_bios_c *bios;
  bx_disk_bios_c *disk_bios;
  Bit8u drvmode1[NUM_FLOPPY];
  Bit16u drvmode2[NUM_FLOPPY];

  BX_FD_BIOS_SMF void   floppy_xfer(Bit8u drive, Bit32u offset, Bit8u *buffer, Bit32u bytes, Bit8u direction);
  BX_FD_BIOS_SMF Boolean evaluate_media(unsigned type, char *path, floppy_t *floppy);
  };


#if BX_USE_FDBIOS_SMF
extern bx_fd_bios_c bx_fd_bios;
#endif
